#include "Sample.h"

#include "UtilStr.h"
#include "V3.h"
#include "R3Matrix.h"
		
Sample::Sample() {
	mNext			= NULL;
	mSampleTime		= -1;
}

#define BINS_TO_COMPARE	10

void Sample::Assign( long inCurTime, const float inSample[], const Sample* inPrev, float inFalloff ) {
	const float*	prev = NULL;
	float			w, bin, sum;
	long			j, i, idx;
	bool			done = false;
	
	mSampleTime = inCurTime;

	if ( inPrev ) {
		w = inFalloff * ((float) ( mSampleTime - inPrev -> mSampleTime ));
		if ( w < 1.0 ) {
			prev = inPrev -> mSample;
			for ( i = 0; i < NUM_SAMPLE_BINS; i++ ) {
				bin = inSample[ i ];
				mSample[ i ] = w * bin + (1.0 - w) * prev[ i ];
			}
			done = true;
		} 
	}
	
	if ( ! done ) {
		UtilStr::Move( mSample, inSample, sizeof( float ) * NUM_SAMPLE_BINS );
	}
	
	// Calculate bass1
	// Assign mBassLvl here -- choose the larger bins
	char chosen[ NUM_SAMPLE_BINS ];
	for ( i = 0; i < BINS_TO_COMPARE; i++ )
		chosen[ i ] = 0;

	sum = 0;
	for ( j = 0; j < 4; j++ ) {
	
		// Default to the bin not taken yet
		for ( idx = 0; chosen[ idx ]; idx++ ) { 
		}
		bin = inSample[ idx ];
		
		// Find next largest bin, then 'take'/'choose' it
		for ( i = idx + 1; i < BINS_TO_COMPARE; i++ ) {
			if ( mSample[ i ] > bin && chosen[ i ] == 0 ) {
				bin = mSample[ i ];
				idx = i;
			}
		}
		
		sum += bin;
		chosen[ idx ] = 1;
	}
	mBass[ 0 ] = sum;
	
	
	// Calculate bass2
	sum = 0;
	for ( i = 0; i < 10; i++ ) {
		sum += mSample[ i ];
	}
	mBass[ 1 ] = sum;
	
	
	// Calculate bass3
	sum = 0;
	if ( inPrev ) {
		if ( mSampleTime - inPrev -> mSampleTime < 500 ) {
			w = 1.0 / ( (float) ( inCurTime - inPrev -> mSampleTime ) );
			prev = inPrev -> mSample;
			for ( i = 0; i < 16; i++ ) {
				bin = mSample[ i ] - prev[ i ];
				if ( bin > 0 )
					sum += w * bin;
			}
		}
	}
	mBass[ 2 ] = sum;
}
		
		
	/*
void Sample::GenerateCords( V3* ioPts, float* inTail, V3& inOffset, R3Matrix& inT, float inScale, float inPersIntcpt ) {
	float mag, x, y, z;

	for ( int i = 0; i < NUM_SAMPLE_BINS; i++ ) {
		mag = mSample[ i ];
		x =		*inTail;		inTail++;
		y =		*inTail;		inTail++;
		z =		*inTail;		inTail++;
		x +=	mag * *inTail;	inTail++;
		y +=	mag * *inTail;	inTail++;
		z +=	mag * *inTail;	inTail++;
		ioPts -> mX = x - inOffset.mX;
		ioPts -> mY = y - inOffset.mY;
		ioPts -> mZ = z - inOffset.mZ;
		ioPts -> transform( inT );
		ioPts -> mX = inScale * ioPts -> mX / ( ioPts -> mZ + inPersIntcpt );
		ioPts -> mY = inScale * ioPts -> mY / ( ioPts -> mZ + inPersIntcpt );
		ioPts++;
	}
}
*/

